﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Iterators
{
    class Program
    {
        // Listing 5-29
        public static IEnumerable<int> Numbers(int start, int count)
        {
            for (int i = 0; i < count; ++i)
            {
                yield return start + i;
            }
        }

        static void Main(string[] args)
        {
            foreach (int i in Numbers(1, 5))
            {
                Console.WriteLine(i);
            }

            // Tych kilka kolejnych wierszy kodu nie należy do listingu 5.29.
            // Służą one do wykonania pozostałych przykładów związanych z iteratorami.
            Examples30_31.InvokeSimpleIterator();
            Examples30_31.InvokeEndlessIterator();
            Example32.UseHandWrittenEnumerable();
            Example33.IteratorWithException();
        }
    }
}
